/******************************************************************************
**
** Copyright (C) 2021 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of the QtKnx module.
**
** $QT_BEGIN_LICENSE:COMM$
**
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** $QT_END_LICENSE$
**
**
**
**
**
**
**
**
**
****************************************************************************/

#ifndef QKNXNETIPHPAI_H
#define QKNXNETIPHPAI_H

#include <QtKnx/qtknxglobal.h>
#include <QtKnx/qknxnetipstruct.h>
#include <QtNetwork/qhostaddress.h>

QT_BEGIN_NAMESPACE

class Q_KNX_EXPORT QKnxNetIpHpaiProxy final
{
public:
    QKnxNetIpHpaiProxy() = delete;
    ~QKnxNetIpHpaiProxy() = default;

    QKnxNetIpHpaiProxy(const QKnxNetIpHpai &&) = delete;
    explicit QKnxNetIpHpaiProxy(const QKnxNetIpHpai &hpai);

    bool isValid() const;

    QKnxNetIp::HostProtocol hostProtocol() const;
    QHostAddress hostAddress() const;
    quint16 port() const;

    class Q_KNX_EXPORT Builder final
    {
    public:
        Builder &setHostProtocol(QKnxNetIp::HostProtocol code);
        Builder &setHostAddress(const QHostAddress &address);
        Builder &setPort(quint16 port);

        QKnxNetIpHpai create() const;

    private:
        QKnxNetIp::HostProtocol m_code { QKnxNetIp::HostProtocol::UDP_IPv4 };
        QHostAddress m_address { QHostAddress::Null };
        quint16 m_port { 0 };
    };
    static QKnxNetIpHpaiProxy::Builder builder();

private:
     const QKnxNetIpHpai &m_hpai;
};

QT_END_NAMESPACE

#endif
